local super = require "Control"

Button = super:new()

function Button:new()
    self = super.new(self)
    
    self.status = false
    
    return self
end

function Button:buttonRect()
    return self:rect()
end

function Button:down(x, y)
    if self:buttonRect():contains(x, y) then
        self:setStatus(true)
        return true
    end
end

function Button:dragged(x, y)
    local newStatus = self:buttonRect():contains(x, y)
    if newStatus ~= self:getStatus() then
        self:setStatus(newStatus)
    end
end

function Button:up()
    if self:getStatus() then
        self:setStatus(false)
        self:action()
    end
end

function Button:getStatus()
    return self.status
end

function Button:setStatus(value)
    self.status = value
    self:invalidate()
end

return Button
